<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="refno"></xsl:variable>
<xsl:variable name="partno"></xsl:variable>
<xsl:variable name="blockno"></xsl:variable>
<xsl:template match="/">
	<table border="1" cellspacing="0" cellpadding="3" width="100%" bordercolordark="#FFFFFF" bordercolor="#777777" id="tbl">
		<tr height='24' style='color:captiontext;' bgcolor='activecaption'>
			<th colspan='2'>
				<div align='left'>
					PARTS ORDER
				</div>
			</th>
		</tr>
		<xsl:apply-templates select="//ROW[SYMBOL=$refno and PART_NO=$partno and BLOCK_NO=$blockno]">
		</xsl:apply-templates>
	</table>
	<table border="0" align="center" cellspacing="5">
		<xsl:apply-templates select="//ROW[SYMBOL=$refno and PART_NO=$partno and BLOCK_NO=$blockno]/SYMBOL">
		</xsl:apply-templates>
	</table>
</xsl:template>

<xsl:template match="/PARTSLIST/ROW/SYMBOL">
	<tr>
		<td>
			<input type="button" id="btn" value="Into Basket">
				<xsl:attribute name="onClick">
					intoBasket('<xsl:value-of select="."/>','<xsl:value-of select="../PART_NO"/>','<xsl:value-of select="../PART_NAME"/>','<xsl:value-of select="../BLOCK_NO"/>');
				</xsl:attribute>
			</input>
		</td>
		<td>
			<input type="button" id="btn" value="Cancel" onClick="window.close();"/>
		</td>
	</tr>
</xsl:template>

<xsl:template match="/PARTSLIST/ROW">
	<tr>
<!--
		<th bgcolor="threedface" align="left" style="font-family:JVC Service,Arial,Helvetica">!</th>
-->
		<th bgcolor="threedface" align="left"><img src="../js/safety.png" width="12" height="10" border="0"/></th>
		<td width="300">
			<xsl:if test="SAFETY_FLG[. != '']">
<!--
				<xsl:attribute name="style">font-family:JVC Service,Arial,Helvetica</xsl:attribute>
				<xsl:value-of select="SAFETY_FLG"/>
-->
				<img src="../js/safety.png" width="12" height="10" border="0"/>
			</xsl:if>
			<xsl:if test="SAFETY_FLG[. = '']">
				<br/>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left">
			REF
		</th>
		<td width="300">
			<xsl:if test="SYMBOL[. != '']"><xsl:value-of select="SYMBOL"/></xsl:if>
			<xsl:if test="SYMBOL[. = '']"><br/></xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left">
			OR
		</th>
		<td width="300">
			<xsl:if test="OR_FLG[. != '']"><xsl:value-of select="OR_FLG"/></xsl:if>
			<xsl:if test="OR_FLG[. = '']"><br/></xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left">
			PARTS NO.
		</th>
		<td width="300">
			<xsl:if test="PART_NO[. != '']"><xsl:value-of select="PART_NO"/></xsl:if>
			<xsl:if test="PART_NO[. = '']"><br/></xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left">
			PARTS NAME
		</th>
		<td width="300">
			<xsl:if test="PART_NAME[. != '']"><xsl:value-of select="PART_NAME"/></xsl:if>
			<xsl:if test="PART_NAME[. = '']"><br/></xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left">
			DISCRIPTION
		</th>
		<td width="300">
			<xsl:if test="DESCRIPTION[. != '']"><xsl:value-of select="DESCRIPTION"/></xsl:if>
			<xsl:if test="DESCRIPTION[. = '']"><br/></xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left">
			BLOCK
		</th>
		<td width="300">
			<xsl:if test="BLOCK_NO[. != '']"><xsl:value-of select="BLOCK_NO"/></xsl:if>
			<xsl:if test="BLOCK_NO[. = '']"><br/></xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left">
			QTY
		</th>
		<td width="300">
			<input type="text" id="qty" name="orderqty" value="1" size="10" onkeypress="toNum()"/>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
